package org.codeberg.zenxarch.zombies.entity.variant;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.impl.attachment.AttachmentRegistryImpl;
import net.minecraft.class_10695;
import net.minecraft.class_10699;
import net.minecraft.class_10701;
import net.minecraft.class_10702;
import net.minecraft.class_2960;

public record MobVariant(
    Map<AttachmentType<?>, Object> components, class_10702 spawnConditions)
    implements class_10695<class_10701, class_10699> {

  private static final Codec<Map<AttachmentType<?>, Object>> COMPONENT_CODEC =
      Codec.dispatchedMap(
          class_2960.field_25139.comapFlatMap(MobVariant::getAttachment, AttachmentType::identifier),
          AttachmentType::persistenceCodec);

  public static final Codec<MobVariant> CODEC =
      RecordCodecBuilder.create(
          instance ->
              instance
                  .group(
                      COMPONENT_CODEC.fieldOf("components").forGetter(MobVariant::components),
                      class_10702.field_56286
                          .fieldOf("spawnConditions")
                          .forGetter(MobVariant::spawnConditions))
                  .apply(instance, MobVariant::new));

  private static DataResult<AttachmentType<?>> getAttachment(class_2960 id) {
    var attachmentType = AttachmentRegistryImpl.get(id);
    if (attachmentType == null) return DataResult.error(() -> "Attachment Type does not exist");
    if (attachmentType.persistenceCodec() == null)
      return DataResult.error(() -> "Attachment Type is not persistent", attachmentType);
    return DataResult.success(attachmentType);
  }

  @Override
  public List<class_10696<class_10701, class_10699>> method_67126() {
    return this.spawnConditions.comp_3583();
  }
}
