package org.codeberg.zenxarch.zombies.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.data.entity.MobAttachments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin {
  @Inject(at = @At("HEAD"), method = "isInvulnerableTo", cancellable = true)
  public void zenxarch$implement_damage_invulnerability(
      class_3218 world, class_1282 source, CallbackInfoReturnable<Boolean> cir) {
    var living = (class_1309) (Object) this;
    if (!living.hasAttached(MobAttachments.INVULNERABLE_TO)) return;
    var damageTypes = living.getAttached(MobAttachments.INVULNERABLE_TO);
    if (damageTypes.method_40241(source.method_48793())) cir.setReturnValue(true);
  }
}
