package org.codeberg.zenxarch.zombies.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Optional;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.minecraft.class_1308;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import org.codeberg.zenxarch.zombies.data.entity.MobAttachments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1308.class)
public abstract class MobEntityMixin implements AttachmentTarget {

  @ModifyReturnValue(method = "getLootTableKey", at = @At("RETURN"))
  private Optional<class_5321<class_52>> zenxarch$override_loot_table(
      Optional<class_5321<class_52>> lootTable) {
    if (this.hasAttached(MobAttachments.LOOT_TABLE))
      return Optional.of(this.getAttached(MobAttachments.LOOT_TABLE));
    return lootTable;
  }
}
