/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.math;

import com.google.common.collect.AbstractIterator;
import net.minecraft.class_5819;

public record IntRange(int min, int max) {
    public static final IntRange INVALID = IntRange.of(0, -1);

    public static IntRange of(int min, int max) {
        return new IntRange(min, max);
    }

    public static IntRange of(int range) {
        return new IntRange(-range, range);
    }

    public static IntRange around(int center, int range) {
        return IntRange.of(range).shiftBy(center);
    }

    public boolean isValid() {
        return this.min <= this.max;
    }

    public IntRange union(IntRange other) {
        return IntRange.of(Math.min(this.min, other.min), Math.max(this.max, other.max));
    }

    public IntRange intersection(IntRange other) {
        return IntRange.of(Math.max(this.min, other.min), Math.min(this.max, other.max));
    }

    public int next(class_5819 random) {
        if (!this.isValid()) {
            return this.min;
        }
        return random.method_39332(this.min, this.max);
    }

    public IntRange shiftBy(int shift) {
        return IntRange.of(this.min + shift, this.max + shift);
    }

    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    public Iterable<Integer> iterate() {
        return () -> new AbstractIterator<Integer>(){
            int value;
            {
                this.value = IntRange.this.min;
            }

            protected Integer computeNext() {
                if (this.value > IntRange.this.max) {
                    return (Integer)this.endOfData();
                }
                return this.value++;
            }
        };
    }
}

