/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.spawning;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.mob_variants_api.registry.MobRegistryKeys;
import org.codeberg.zenxarch.mob_variants_api.registry.MobVariantUtils;
import org.codeberg.zenxarch.mob_variants_api.variant.MobVariant;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.jetbrains.annotations.Nullable;

public final class ZombieNbtUtils {
    private static final String ZOMBIE_ID_KEY = "zenxarch_zombie_id";

    private ZombieNbtUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Optional<class_6880<MobVariant>> getVariantFromView(class_1937 world, class_11368 view) {
        Optional idKey = view.method_71441(ZOMBIE_ID_KEY);
        if (idKey.isEmpty()) {
            return Optional.empty();
        }
        String string = (String)idKey.get();
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"", String.class}, (Object)string2, n)) {
            case 0 -> {
                Optional var5_5;
                yield var5_5 = Optional.empty();
            }
            default -> {
                String id = string2;
                try {
                    Optional var5_6;
                    yield var5_6 = MobVariantUtils.getOptionalVariant((class_1937)world, (class_2960)MobVariantUtils.toId((String)id));
                }
                catch (Exception e) {
                    Optional var5_7;
                    Zombies.LOGGER.info("Exception caught: {}", (Object)e.getMessage());
                    yield var5_7 = Optional.empty();
                }
            }
        };
    }

    public static void setVariantToView(class_1937 world, class_11372 view, @Nullable class_6880<MobVariant> variant) {
        Optional registry = world.method_30349().method_46759(MobRegistryKeys.MOB_VARIANT);
        if (registry.isEmpty()) {
            return;
        }
        if (variant == null) {
            return;
        }
        view.method_71469(ZOMBIE_ID_KEY, variant.method_55840());
    }

    public static Optional<class_1297> loadFromView(class_11368 view, class_1937 world) {
        return ZombieNbtUtils.getVariantFromView(world, view).map(variant -> ZombieNbtUtils.loadFromView(world, (class_6880<MobVariant>)variant, view));
    }

    private static ExtendedZombieEntity loadFromView(class_1937 world, class_6880<MobVariant> variant, class_11368 view) {
        ExtendedZombieEntity result = new ExtendedZombieEntity(world);
        result.method_5651(view);
        return result;
    }
}

