/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.spawning.provider;

import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.codeberg.zenxarch.zombies.math.IntRange;
import org.codeberg.zenxarch.zombies.spawning.SpawnUtils;

@FunctionalInterface
public interface PosRangeProvider {
    public static final int SPAWN_RANGE = 80;
    public static final PosRangeProvider ZERO_BLOCKLIGHT = (world, pos, center) -> {
        class_2338.class_2339 mutable = pos.method_25503();
        while (mutable.method_10264() >= pos.method_10264() - 16) {
            if (world.method_8314(class_1944.field_9282, (class_2338)mutable) >= 2) {
                mutable.method_10104(class_2350.field_11033, 2);
                continue;
            }
            if (world.method_8314(class_1944.field_9282, (class_2338)mutable) != 1) break;
            mutable.method_10098(class_2350.field_11033);
        }
        int startY = mutable.method_10264();
        while (mutable.method_10264() >= pos.method_10264() - 16 && world.method_8314(class_1944.field_9282, (class_2338)mutable) == 0) {
            mutable.method_10098(class_2350.field_11033);
        }
        return IntRange.of(mutable.method_10264(), startY);
    };
    public static final PosRangeProvider AROUND_CENTER = (world, pos, center) -> {
        int relz;
        int relx = center.method_10263() - pos.method_10263();
        IntRange result = PosRangeProvider.getSpawnRangeFor(relx, relz = center.method_10260() - pos.method_10260());
        if (!result.isValid()) {
            return IntRange.INVALID;
        }
        result = result.shiftBy(center.method_10264());
        return result;
    };
    public static final PosRangeProvider HEIGHTMAP_BOUNDS = (world, pos, center) -> SpawnUtils.getBounds(world, pos);

    public IntRange get(class_3218 var1, class_2338 var2, class_2338 var3);

    private static IntRange getSpawnRangeFor(int x, int z) {
        int sqDist = x * x + z * z;
        int radSq = 6400;
        if (sqDist >= radSq) {
            return IntRange.INVALID;
        }
        int y = class_3532.method_15384((double)Math.sqrt((double)radSq - (double)sqDist));
        return IntRange.of(y);
    }
}

