package org.codeberg.zenxarch.zombies.data.entity.effect.pair;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10699;
import net.minecraft.class_10701;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.data.entity.effect.MobEffect;
import org.jetbrains.annotations.Nullable;

public record ConditionalSpawnEffect(class_10699 condition, MobEffect effect, boolean forSelf)
    implements MobEffect {

  public static final MapCodec<ConditionalSpawnEffect> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      class_10699.field_56284
                          .fieldOf("condition")
                          .forGetter(ConditionalSpawnEffect::condition),
                      MobEffect.CODEC.fieldOf("effect").forGetter(ConditionalSpawnEffect::effect),
                      Codec.BOOL.fieldOf("forSelf").forGetter(ConditionalSpawnEffect::forSelf))
                  .apply(instance, ConditionalSpawnEffect::new));

  @Override
  public void run(class_3218 world, class_1308 mob, @Nullable class_1309 adversery) {
    if (!forSelf && adversery == null) return;
    var pos = forSelf ? mob.method_24515() : adversery.method_24515();
    if (condition.test(class_10701.method_67169(world, pos))) effect.run(world, mob, adversery);
  }

  @Override
  public MapCodec<? extends MobEffect> getCodec() {
    return CODEC;
  }
}
