package org.codeberg.zenxarch.zombies.registry;

import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7922;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.data.entity.effect.LivingEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.MobEffect;
import org.codeberg.zenxarch.zombies.entity.variant.MobVariant;

public interface ZombieRegistries {

  private static <T> class_7922<MapCodec<? extends T>> createRegistry(
      class_5321<class_2378<MapCodec<? extends T>>> key) {
    return FabricRegistryBuilder.createDefaulted(key, Zombies.id("default")).buildAndRegister();
  }

  public static final class_7922<MapCodec<? extends LivingEffect>> LIVING_EFFECT =
      createRegistry(ZombieRegistryKeys.LIVING_EFFECT);

  public static final class_7922<MapCodec<? extends MobEffect>> MOB_EFFECT =
      createRegistry(ZombieRegistryKeys.MOB_EFFECT);

  public static void init() {
    MobEffect.init();
    LivingEffect.init();
    DynamicRegistries.register(ZombieRegistryKeys.MOB_VARIANT, MobVariant.CODEC);
  }
}
