package org.codeberg.zenxarch.mob_variants_api.spawn_conditions;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_10699;
import net.minecraft.class_2378;
import net.minecraft.class_7923;
import org.codeberg.zenxarch.mob_variants_api.MobVariantsApiMod;

public final class MobSpawnConditions {
  private MobSpawnConditions() {
    throw new IllegalStateException("Utility class");
  }

  public static void initialize() {
    register("is_day", DaySpawnCondition.CODEC);
    register("is_night", NightSpawnCondition.CODEC);
    register("negate", NegateSpawnCondition.CODEC);
    register("all_of", AllOfSpawnCondition.CODEC);
    register("is_raining", RainingSpawnCondition.CODEC);
    register("is_thundering", ThunderingSpawnCondition.CODEC);
    register("precipitation", PrecipitationSpawnCondition.CODEC);
  }

  private static void register(String id, MapCodec<? extends class_10699> codec) {
    class_2378.method_10230(class_7923.field_56403, MobVariantsApiMod.id(id), codec);
  }
}
