/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.mob_variants_api.variant.effect;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1293;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_9734;
import org.codeberg.zenxarch.mob_variants_api.MobVariantsApiMod;
import org.codeberg.zenxarch.mob_variants_api.registry.MobRegisteries;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.LivingEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.AllOfMobEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.ConditionalSpawnEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.ConvertToEntityTypeEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.DefaultMobEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.HealFromDamage;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.IntervalMobEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.RandomMobEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.SingleMobEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.StatusMobEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.pair.SwapMobEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.single.FreezeEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.single.IgniteEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.single.SpawnParticleEffect;
import org.jetbrains.annotations.Nullable;

public interface MobEffect {
    public static final Codec<MobEffect> CODEC = Codec.withAlternative((Codec)MobRegisteries.MOB_EFFECT.method_39673().dispatch(MobEffect::getCodec, Function.identity()), (Codec)DefaultMobEffect.CODEC.codec());

    public void run(class_3218 var1, class_1308 var2, @Nullable class_1309 var3);

    public MapCodec<? extends MobEffect> getCodec();

    public static void init() {
        MobEffect.register("default", DefaultMobEffect.CODEC);
        MobEffect.register("all_of", AllOfMobEffect.CODEC);
        MobEffect.register("random", RandomMobEffect.CODEC);
        MobEffect.register("single", SingleMobEffect.CODEC);
        MobEffect.register("status_effect", StatusMobEffect.CODEC);
        MobEffect.register("swap", SwapMobEffect.CODEC);
        MobEffect.register("conditional", ConditionalSpawnEffect.CODEC);
        MobEffect.register("heal", HealFromDamage.CODEC);
        MobEffect.register("convert_to", ConvertToEntityTypeEffect.CODEC);
        MobEffect.register("interval", IntervalMobEffect.CODEC);
    }

    private static void register(String id, MapCodec<? extends MobEffect> codec) {
        class_2378.method_10230(MobRegisteries.MOB_EFFECT, (class_2960)MobVariantsApiMod.id(id), codec);
    }

    public static SwapMobEffect swapPositions() {
        return SwapMobEffect.create();
    }

    public static SingleMobEffect toPlayer(LivingEffect effect) {
        return new SingleMobEffect(effect, false);
    }

    public static SingleMobEffect toMob(LivingEffect effect) {
        return new SingleMobEffect(effect, true);
    }

    public static SingleMobEffect ignite(float seconds) {
        return MobEffect.toPlayer(new IgniteEffect(seconds));
    }

    public static SingleMobEffect freeze() {
        return MobEffect.toPlayer(FreezeEffect.create());
    }

    public static MobEffect random(MobEffect ... effect) {
        return RandomMobEffect.create(effect);
    }

    public static MobEffect statusEffect(class_1293 ... builders) {
        if (builders.length == 0) {
            return DefaultMobEffect.create();
        }
        return new StatusMobEffect(List.of(builders));
    }

    public static SingleMobEffect spawnParticles(class_2394 particle, class_9734.class_9735 horizontalPosition, class_9734.class_9735 verticalPosition, class_9734.class_9738 horizontalVelocity, class_9734.class_9738 verticalVelocity, class_5863 speed) {
        return MobEffect.toMob(new SpawnParticleEffect(new class_9734(particle, horizontalPosition, verticalPosition, horizontalVelocity, verticalVelocity, speed)));
    }

    public static SingleMobEffect spawnParticles(class_2394 particle, float speed) {
        class_5862 floatProvider = class_5862.method_33908((float)speed);
        return MobEffect.spawnParticles(particle, class_9734.method_60252(), class_9734.method_60252(), class_9734.method_60250((class_5863)floatProvider), class_9734.method_60250((class_5863)floatProvider), (class_5863)floatProvider);
    }
}

