package org.codeberg.zenxarch.mob_variants_api.variant.effect.single;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.LivingEffect;

public record RemoveAttributeModifierEffect(
    class_6880<class_1320> attribute, List<class_1322> modifiers)
    implements LivingEffect {

  public static final MapCodec<RemoveAttributeModifierEffect> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      class_1320.field_51575
                          .fieldOf("attribute")
                          .forGetter(RemoveAttributeModifierEffect::attribute),
                      class_5699.method_65313(class_1322.field_46247)
                          .fieldOf("modifiers")
                          .forGetter(RemoveAttributeModifierEffect::modifiers))
                  .apply(instance, RemoveAttributeModifierEffect::new));

  @Override
  public void run(class_3218 world, class_1309 target) {
    var instance = target.method_5996(attribute);
    if (instance == null) return;
    for (var modifier : modifiers) instance.method_6202(modifier);
  }

  @Override
  public MapCodec<? extends LivingEffect> getCodec() {
    return CODEC;
  }
}
