/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.spawning;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.difficulty.ExtendedDifficulty;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.codeberg.zenxarch.zombies.spawning.SpawnProvider;
import org.codeberg.zenxarch.zombies.spawning.ZombieDensityMap;

public class ZombieApocalypse {
    private class_3218 world;
    private Object2IntMap<class_2382> zombieCount;

    public ZombieApocalypse(class_3218 world) {
        this.world = world;
    }

    public Object2IntMap<class_2382> getZombieCount() {
        return this.zombieCount;
    }

    private void spawnZombie(ExtendedZombieEntity zombie) {
        if (this.world.method_64395().method_8355(ZombieGamerules.ZOMBIE_TARGET_PLAYER_ON_SPAWN)) {
            zombie.method_5980((class_1309)this.world.method_8604(zombie.method_23317(), zombie.method_23318(), zombie.method_23321(), 64.0, class_1301.field_6157.and(class_1301.field_6156)));
        }
        zombie.initialize((class_5425)this.world);
        this.world.method_30771((class_1297)zombie);
    }

    private Optional<ExtendedZombieEntity> createZombie(class_2338 pos) {
        ExtendedZombieEntity zombie = new ExtendedZombieEntity((class_1937)this.world);
        zombie.method_5725(pos, this.world.field_9229.method_43057() * 360.0f, 0.0f);
        if (zombie.method_5957((class_4538)this.world)) {
            return Optional.of(zombie);
        }
        return Optional.empty();
    }

    private void spawnZombie(class_3222 player, class_2338 pos, ExtendedDifficulty difficulty) {
        this.createZombie(pos).ifPresent(this::spawnZombie);
    }

    public void spawnZombiesNear(class_3222 player, List<class_2338> positions) {
        Object2IntMap<class_2382> subMap;
        int total;
        ExtendedDifficulty difficulty = new ExtendedDifficulty(this.world, player.method_24515());
        int toSpawn = difficulty.getMaxZombies();
        if (toSpawn <= (total = (subMap = ZombieDensityMap.getSubMap(this.zombieCount, player.method_24515())).values().intStream().sum())) {
            return;
        }
        SpawnProvider.giveSpawnPositions(this.world, player.method_24515(), positions, subMap, toSpawn).ifPresent(pos -> this.spawnZombie(player, (class_2338)pos, difficulty));
    }

    public Object2IntMap<class_2382> countZombies() {
        Object2IntArrayMap result = new Object2IntArrayMap();
        for (class_1297 entity : this.world.method_27909()) {
            if (!(entity instanceof ExtendedZombieEntity)) continue;
            ExtendedZombieEntity zombie = (ExtendedZombieEntity)entity;
            ZombieDensityMap.push((Object2IntMap<class_2382>)result, zombie.method_24515());
        }
        return result;
    }

    public static List<class_3222> players(class_3218 world) {
        return world.method_18766(class_1301.field_6157.and(class_1301.field_6155));
    }

    public void spawn(class_3218 world, boolean spawnMonsters) {
        this.world = world;
        if (!spawnMonsters || this.world.method_8407().equals((Object)class_1267.field_5801) || !this.world.method_64395().method_8355(ZombieGamerules.DO_ZOMBIE_SPAWNING)) {
            return;
        }
        List<class_3222> players = ZombieApocalypse.players(world);
        List<class_2338> positions = players.stream().map(class_1297::method_24515).toList();
        this.zombieCount = this.countZombies();
        for (class_3222 player : players) {
            this.spawnZombiesNear(player, positions);
        }
    }

    public static boolean isApocalypticWorld(class_3218 world) {
        return world.method_27983().equals(class_1937.field_25179);
    }
}

