package org.codeberg.zenxarch.zombies;

import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_8828;

public final class ZombieGamerules {

  private ZombieGamerules() {
    throw new IllegalStateException("Utility class");
  }

  public static final CustomGameRuleCategory ZOMBIES_GENERAL =
      new CustomGameRuleCategory(
          Zombies.id("general"),
          class_5250.method_43477(class_8828.method_54232("Zombies"))
              .method_10862(class_2583.field_24360.method_10977(class_124.field_1054)));

  private static class_1928.class_4313<class_1928.class_4312> newGameRule(String name, int defaultValue) {
    return GameRuleRegistry.register(
        name, ZOMBIES_GENERAL, GameRuleFactory.createIntRule(defaultValue));
  }

  private static class_1928.class_4313<class_1928.class_4310> newGameRule(
      String name, boolean defaultValue) {
    return GameRuleRegistry.register(
        name, ZOMBIES_GENERAL, GameRuleFactory.createBooleanRule(defaultValue));
  }

  public static final class_1928.class_4313<class_1928.class_4312> MAX_ZOMBIES = newGameRule("maxZombies", 150);

  public static final class_1928.class_4313<class_1928.class_4312> SPAWN_SPEED =
      newGameRule("fillZombieCapOverSeconds", 30);

  public static final class_1928.class_4313<class_1928.class_4310> ZOMBIES_BURN_IN_DAYLIGHT =
      newGameRule("zombiesBurnInDaylight", false);

  public static final class_1928.class_4313<class_1928.class_4310> DO_ZOMBIE_SPAWNING =
      newGameRule("doZombieSpawning", true);

  public static final class_1928.class_4313<class_1928.class_4310> ZOMBIE_TARGET_PLAYER_ON_SPAWN =
      newGameRule("zombieTargetPlayerOnSpawn", false);

  public static void initialize() {
    /* force load class */
  }
}
