package org.codeberg.zenxarch.zombies.datagen;

import com.mojang.serialization.Lifecycle;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import org.codeberg.zenxarch.zombies.entity.ZombieVariants;

public class ZDynamicRegistryProvider extends FabricDynamicRegistryProvider {
  public ZDynamicRegistryProvider(
      FabricDataOutput output, CompletableFuture<class_7874> registriesFuture) {
    super(output, registriesFuture);
  }

  @Override
  public String method_10321() {
    return "zenxarch Dynamic Registries";
  }

  @Override
  protected void configure(class_7874 registries, Entries entries) {
    ZEnchantmentProviders.bootstrap(createRegisterable(registries, entries));
    ZombieVariants.bootstrap(createRegisterable(registries, entries));
  }

  private static <T> class_7891<T> createRegisterable(
      class_7225.class_7874 registries, Entries entries) {
    return new class_7891<T>() {
      @Override
      public class_6880.class_6883<T> method_46800(class_5321<T> key, T value, Lifecycle lifecycle) {
        return (class_6880.class_6883<T>) entries.add(key, value);
      }

      @Override
      public <S> class_7871<S> method_46799(
          class_5321<? extends class_2378<? extends S>> registryRef) {
        return registries.method_46762(registryRef);
      }
    };
  }
}
