package org.codeberg.zenxarch.zombies.entity;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4095.class_5303;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.LeapAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.AvoidSun;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.EscapeSun;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.GenericAttackTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtil;
import net.tslat.smartbrainlib.util.SensoryUtil;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.difficulty.ExtendedDifficulty;
import org.codeberg.zenxarch.zombies.entity.effect.ZombieEffect;
import org.codeberg.zenxarch.zombies.entity.variant.ZombieVariant;
import org.codeberg.zenxarch.zombies.registry.ZombieRegistryKeys;
import org.codeberg.zenxarch.zombies.spawning.ZombieApocalypse;
import org.jetbrains.annotations.Nullable;

public class ExtendedZombieEntity extends class_1642
    implements SmartBrainOwner<ExtendedZombieEntity> {

  private class_6880<ZombieVariant> variant;

  public ExtendedZombieEntity(class_1937 world) {
    super(world);
  }

  @Override
  protected class_5303<?> method_28306() {
    return new SmartBrainProvider<>(this);
  }

  private static boolean shouldTargetEntity(class_1309 living, ExtendedZombieEntity zombie) {
    if (!zombie.canTarget(living)) return false;
    return switch (living) {
      case TurtleEntity turtle -> turtle.isBaby() && !turtle.isTouchingWater();
      default ->
          living instanceof PlayerEntity
              || living instanceof MerchantEntity
              || living instanceof IronGolemEntity;
    };
  }

  @Override
  public List<ExtendedSensor<ExtendedZombieEntity>> getSensors() {
    return ObjectArrayList.of(
        new NearbyPlayersSensor<>(),
        new NearbyLivingEntitySensor<ExtendedZombieEntity>()
            .setPredicate(ExtendedZombieEntity::shouldTargetEntity),
        new HurtBySensor<ExtendedZombieEntity>()
            .setPredicate((source, living) -> !(living instanceof ExtendedZombieEntity)),
        new GenericAttackTargetSensor<>(),
        new UnreachableTargetSensor<>());
  }

  @Override
  public BrainActivityGroup<? extends ExtendedZombieEntity> getCoreTasks() {
    return BrainActivityGroup.coreTasks(
        new AvoidSun<ExtendedZombieEntity>().startCondition(ExtendedZombieEntity::method_7216),
        new EscapeSun<ExtendedZombieEntity>()
            .startCondition(ExtendedZombieEntity::method_7216)
            .cooldownFor(zombie -> 20),
        new LookAtAttackTarget<>().runFor(zombie -> zombie.method_59922().method_39332(40, 300)),
        new MoveToWalkTarget<>());
  }

  @SuppressWarnings("unchecked")
  @Override
  public BrainActivityGroup<ExtendedZombieEntity> getIdleTasks() {
    return BrainActivityGroup.idleTasks(
        new FirstApplicableBehaviour<ExtendedZombieEntity>(
            new TargetOrRetaliate<>()
                .alertAlliesWhen((a, b) -> b instanceof class_1657)
                .cooldownFor(z -> 20),
            new SetPlayerLookTarget<>(),
            new SetRandomLookTarget<>()),
        new OneRandomBehaviour<ExtendedZombieEntity>(
            new SetRandomWalkTarget<>(),
            new Idle<>().runFor(zombie -> zombie.method_59922().method_39332(30, 60))));
  }

  @Override
  public BrainActivityGroup<? extends ExtendedZombieEntity> getFightTasks() {
    return BrainActivityGroup.fightTasks(
        new InvalidateAttackTarget<>(),
        new TargetOrRetaliate<>()
            .alertAlliesWhen((a, b) -> b instanceof class_1657)
            .cooldownFor(z -> 20),
        new SetWalkTargetToAttackTarget<>(),
        new AnimatableMeleeAttack<>(0)
            .whenStarting(zombie -> zombie.method_19540(true))
            .whenStopping(zombie -> zombie.method_19540(false)),
        new LeapAtTarget<>(0) {
          private static final MemoryTest MEMORY_REQUIREMENTS =
              MemoryTest.builder(4)
                  .hasMemories(
                      class_4140.field_22355,
                      class_4140.field_19293,
                      SBLMemoryTypes.TARGET_UNREACHABLE.get())
                  .noMemory(class_4140.field_22475);

          @Override
          protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
          }
        }.startCondition(ExtendedZombieEntity::shouldTryLeaping)
            .whenStarting(zombie -> zombie.method_19540(true))
            .whenStopping(zombie -> zombie.method_19540(false)));
  }

  private static boolean shouldTryLeaping(class_1308 self) {
    var target = BrainUtil.getTargetOfEntity(self);
    return self.method_24828()
        && BrainUtil.getMemory(self, class_4140.field_19293) > 100
        && SensoryUtil.hasLineOfSight(self, target)
        && self.method_5858(target) < 4 * 4;
  }

  @Override
  protected void method_5959() {
    /* use smartbrainlib for ai */
  }

  @Override
  public void method_7201(boolean canBreakDoors) {
    /* no griefing */
  }

  @Override
  protected void method_5958(class_3218 world) {
    super.method_5958(world);
    tickBrain(this);
  }

  @Override
  protected boolean method_7216() {
    if (this.method_37908() instanceof class_3218 sw)
      return sw.method_64395().method_8355(ZombieGamerules.ZOMBIES_BURN_IN_DAYLIGHT);
    return false;
  }

  protected ExtendedDifficulty getExtentedDifficulty(class_5425 serverWorld) {
    return new ExtendedDifficulty(serverWorld.method_8410(), this.method_24515());
  }

  public void initialize(class_5425 world) {
    this.method_5943(world, world.method_8404(this.method_24515()), class_3730.field_16459, null);
  }

  private void executeEvent(
      AttachmentType<ZombieEffect> attachment,
      class_3218 world,
      @Nullable class_1309 adversary) {
    if (!this.hasAttached(attachment)) return;
    this.getAttached(attachment).run(world, this, adversary);
  }

  @Override
  public class_1315 method_5943(
      class_5425 world,
      class_1266 difficulty,
      class_3730 spawnReason,
      class_1315 entityData) {
    ZombieVariants.getRandomVariantFromPos(world.method_8410(), this.method_24515())
        .ifPresent(this::setVariant);
    var result = super.method_5943(world, difficulty, spawnReason, new class_1644(false, false));
    executeEvent(ZombieEntityAttachments.ON_SPAWN, world.method_8410(), null);
    return result;
  }

  @Override
  protected void method_5964(class_5819 random, class_1266 unused) {
    /* equipment is initialized in updateEnchantments */
    if (this.hasAttached(ZombieEntityAttachments.EQUIPMENT_TABLE)) return;
    super.method_5964(random, unused);
  }

  @Override
  protected void method_5984(
      class_5425 world, class_5819 random, class_1266 unused) {
    if (this.hasAttached(ZombieEntityAttachments.EQUIPMENT_TABLE))
      ZombieEntityAttachments.initEquipment(
          this,
          world.method_8410(),
          this.getAttached(ZombieEntityAttachments.EQUIPMENT_TABLE),
          getExtentedDifficulty(world));
    else super.method_5984(world, random, unused);
  }

  @Override
  public boolean method_64397(class_3218 world, class_1282 source, float amount) {
    if (!super.method_64397(world, source, amount)) return false;
    executeEvent(
        ZombieEntityAttachments.ON_DAMAGE,
        world,
        source.method_5529() instanceof class_1309 living ? living : null);
    return true;
  }

  @Override
  public boolean method_6121(class_3218 world, class_1297 target) {
    var result = super.method_6121(world, target);
    if (result && target instanceof class_1309 living) {
      executeEvent(ZombieEntityAttachments.ON_ATTACK, world, living);
    }
    return result;
  }

  @Override
  protected void method_23733(@Nullable class_1309 adversary) {
    if (this.method_37908() instanceof class_3218 world)
      executeEvent(ZombieEntityAttachments.ON_KILLED, world, adversary);
    super.method_23733(adversary);
  }

  @Override
  public boolean method_5874(class_3218 world, class_1309 other) {
    var result = super.method_5874(world, other);
    executeEvent(ZombieEntityAttachments.ON_KILL, world, other);
    return result;
  }

  @Override
  public void method_6078(class_1282 damageSource) {
    if (!this.method_31481() && !this.field_6272 && this.method_37908() instanceof class_3218 world) {
      executeEvent(
          ZombieEntityAttachments.ON_DEATH,
          world,
          damageSource.method_5529() instanceof class_1309 adversery ? adversery : null);
    }
    super.method_6078(damageSource);
  }

  @Override
  public void method_5773() {
    if (this.method_37908() instanceof class_3218 world)
      executeEvent(ZombieEntityAttachments.ON_TICK, world, null);
    super.method_5773();
  }

  @Override
  protected void method_6001() {
    this.method_5996(class_5134.field_23727).method_6192(0.0);
  }

  @Override
  protected void method_7205(float chanceMultiplier) {
    super.method_7205(chanceMultiplier);
    this.method_5996(class_5134.field_23727)
        .method_6200(class_2960.method_60656("leader_zombie_bonus"));
  }

  @Override
  public void method_5749(class_2487 nbt) {
    super.method_5749(nbt);
    ZombieApocalypse.getVariantFromNbt(this.method_37908(), nbt).ifPresent(this::setVariant);
  }

  @Override
  public void method_5652(class_2487 nbt) {
    super.method_5652(nbt);
    var registry = method_37908().method_30349().method_46759(ZombieRegistryKeys.ZOMBIE_VARIANT);
    if (registry.isEmpty()) return;
    nbt.method_10582(ZombieApocalypse.ZOMBIE_ID_KEY, getVariant().method_55840());
  }

  @Override
  public boolean method_5957(class_4538 world) {
    return world.method_8606(this)
        && world.method_17892(this)
        && (this.method_64462() || !world.method_22345(this.method_5829()));
  }

  public void setVariant(class_6880<ZombieVariant> variant) {
    this.variant = variant;
    if (variant != null) this.variant.comp_349().components().forEach(this::setAttachedFromVariant);
  }

  private void setAttachedFromVariant(AttachmentType<?> attachment, Object value) {
    if (!this.hasAttached(attachment)) this.setAttached((AttachmentType<Object>) attachment, value);
  }

  public class_6880<ZombieVariant> getVariant() {
    return this.variant;
  }
}
