package org.codeberg.zenxarch.zombies.entity;

import static org.codeberg.zenxarch.zombies.entity.effect.ZombieEffect.*;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_10692;
import net.minecraft.class_10695;
import net.minecraft.class_10699;
import net.minecraft.class_10701;
import net.minecraft.class_10702;
import net.minecraft.class_1320;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5861;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.data.ZBiomeTags;
import org.codeberg.zenxarch.zombies.entity.effect.AllOfZombieEffect;
import org.codeberg.zenxarch.zombies.entity.effect.ConditionalSpawnEffect;
import org.codeberg.zenxarch.zombies.entity.effect.RandomZombieEffect;
import org.codeberg.zenxarch.zombies.entity.effect.SingleTargetZombieEffect;
import org.codeberg.zenxarch.zombies.entity.effect.ZombieEffect;
import org.codeberg.zenxarch.zombies.entity.effect.single.DefaultAttributeEffect;
import org.codeberg.zenxarch.zombies.entity.spawn_conditions.DaySpawnCondition;
import org.codeberg.zenxarch.zombies.entity.spawn_conditions.NightSpawnCondition;
import org.codeberg.zenxarch.zombies.entity.variant.ZombieVariant;
import org.codeberg.zenxarch.zombies.registry.ZombieRegistryKeys;

public interface ZombieVariants {
  public static class_5321<ZombieVariant> of(String path) {
    return class_5321.method_29179(ZombieRegistryKeys.ZOMBIE_VARIANT, Zombies.id(path));
  }

  private static class_10699 condition(class_7891<ZombieVariant> registry, class_6862<class_1959> tag) {
    var entryList = registry.method_46799(class_7924.field_41236).method_46735(tag);
    return new class_10692(entryList);
  }

  private static class_10702 condition(
      class_7891<ZombieVariant> registry, class_6862<class_1959> tag, int weight) {
    return class_10702.method_67171(condition(registry, tag), weight);
  }

  private static class_10702 condition(int weight) {
    return class_10702.method_67170(weight);
  }

  public static final String COMMON_ZOMBIE = "default";
  public static final String SWAPPING_ZOMBIE = "swapping";
  public static final String FIRE_ZOMBIE = "fire";
  public static final String FREEZE_ZOMBIE = "freeze";

  private static ZombieEffect createAttributeEffect(
      class_6880<class_1320> attribute, class_5863 value) {
    return new SingleTargetZombieEffect(new DefaultAttributeEffect(attribute, value), true);
  }

  private static ZombieEffect attributesOnSpawn() {
    var dayFollowRange = class_5861.method_33900(20.0f, 8.0f, 14.0f, 26.0f);
    var nightFollowRange = class_5861.method_33900(32.0f, 8.0f, 26.0f, 38.0f);
    var dayFollowRangeEffect =
        new ConditionalSpawnEffect(
            DaySpawnCondition.INSTANCE,
            createAttributeEffect(class_5134.field_23717, dayFollowRange),
            true);
    var nightFollowRangeEffect =
        new ConditionalSpawnEffect(
            NightSpawnCondition.INSTANCE,
            createAttributeEffect(class_5134.field_23717, nightFollowRange),
            true);
    var halfHealthEffect =
        createAttributeEffect(class_5134.field_23716, class_5862.method_33908(10.0f));
    var doubleSpeedEffect =
        new ConditionalSpawnEffect(
            NightSpawnCondition.INSTANCE,
            createAttributeEffect(
                class_5134.field_23719, class_5862.method_33908(0.46f)),
            true);

    var optionalEffect = AllOfZombieEffect.create(halfHealthEffect, doubleSpeedEffect);

    return AllOfZombieEffect.create(
        dayFollowRangeEffect,
        nightFollowRangeEffect,
        RandomZombieEffect.create(class_5862.method_33908(0.8f), optionalEffect));
  }

  public static void bootstrap(class_7891<ZombieVariant> registry) {
    var attributesOnSpawn = attributesOnSpawn();
    register(
        registry,
        COMMON_ZOMBIE,
        new ZombieVariantMapBuilder().with(ZombieEntityAttachments.ON_SPAWN, attributesOnSpawn),
        condition(512));
    register(
        registry,
        SWAPPING_ZOMBIE,
        new ZombieVariantMapBuilder()
            .with(ZombieEntityAttachments.ON_ATTACK, swapPositions())
            .with(ZombieEntityAttachments.ON_TICK, spawnParticles(class_2398.field_11214, 0.2F))
            .with(ZombieEntityAttachments.ON_SPAWN, attributesOnSpawn),
        condition(1));

    register(
        registry,
        FIRE_ZOMBIE,
        new ZombieVariantMapBuilder()
            .with(ZombieEntityAttachments.ON_ATTACK, ignite(1.0F))
            .with(ZombieEntityAttachments.ON_TICK, spawnParticles(class_2398.field_11240, 0.2F))
            .with(ZombieEntityAttachments.ON_SPAWN, attributesOnSpawn),
        condition(registry, ZBiomeTags.WITH_FLAME_ZOMBIES, 16));

    register(
        registry,
        FREEZE_ZOMBIE,
        new ZombieVariantMapBuilder()
            .with(ZombieEntityAttachments.ON_ATTACK, freeze())
            .with(ZombieEntityAttachments.ON_TICK, spawnParticles(class_2398.field_28013, 0.2F))
            .with(ZombieEntityAttachments.ON_SPAWN, attributesOnSpawn),
        condition(registry, ZBiomeTags.WITH_FROST_ZOMBIES, 16));
  }

  public static void register(
      class_7891<ZombieVariant> registry,
      String id,
      ZombieVariantMapBuilder componentMap,
      class_10702 condition) {
    registry.method_46838(of(id), new ZombieVariant(componentMap.build(), condition));
  }

  public static void register(
      class_7891<ZombieVariant> registry, String id, ZombieVariant variant) {
    registry.method_46838(of(id), variant);
  }

  static class ZombieVariantMapBuilder {
    private Map<AttachmentType<?>, Object> componentMap = new HashMap<>();

    public <T> ZombieVariantMapBuilder with(AttachmentType<T> attachment, T value) {
      this.componentMap.put(attachment, value);
      return this;
    }

    public Map<AttachmentType<?>, Object> build() {
      return componentMap;
    }
  }

  public static Optional<class_6880.class_6883<ZombieVariant>> getRandomVariantFromPos(
      class_3218 world, class_2338 pos) {
    return class_10695.method_67162(
        world.method_30349().method_30530(ZombieRegistryKeys.ZOMBIE_VARIANT).method_42017(),
        class_6880::comp_349,
        world.method_8409(),
        class_10701.method_67169(world, pos));
  }
}
