package org.codeberg.zenxarch.zombies.entity.effect;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.jetbrains.annotations.Nullable;

public record AllOfZombieEffect(List<ZombieEffect> effects) implements ZombieEffect {

  public static final MapCodec<AllOfZombieEffect> CODEC =
      class_5699.method_65313(ZombieEffect.CODEC)
          .xmap(AllOfZombieEffect::new, AllOfZombieEffect::effects)
          .fieldOf("effects");

  @Override
  public void run(
      class_3218 world, ExtendedZombieEntity zombie, @Nullable class_1309 adversery) {
    for (ZombieEffect effect : effects) effect.run(world, zombie, adversery);
  }

  @Override
  public MapCodec<AllOfZombieEffect> getCodec() {
    return CODEC;
  }

  public static ZombieEffect create(ZombieEffect... effects) {
    if (effects.length == 0) return DefaultZombieEffect.create();
    if (effects.length == 1) return effects[0];
    return new AllOfZombieEffect(List.of(effects));
  }
}
