package org.codeberg.zenxarch.zombies.entity.effect;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10699;
import net.minecraft.class_10701;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.jetbrains.annotations.Nullable;

public record ConditionalSpawnEffect(
    class_10699 condition, ZombieEffect effect, boolean testZombie) implements ZombieEffect {

  public static final MapCodec<ConditionalSpawnEffect> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      class_10699.field_56284
                          .fieldOf("condition")
                          .forGetter(ConditionalSpawnEffect::condition),
                      ZombieEffect.CODEC
                          .fieldOf("effect")
                          .forGetter(ConditionalSpawnEffect::effect),
                      Codec.BOOL
                          .fieldOf("testZombie")
                          .forGetter(ConditionalSpawnEffect::testZombie))
                  .apply(instance, ConditionalSpawnEffect::new));

  @Override
  public void run(
      class_3218 world, ExtendedZombieEntity zombie, @Nullable class_1309 adversery) {
    if (!testZombie && adversery == null) return;
    var pos = testZombie ? zombie.method_24515() : adversery.method_24515();
    if (condition.test(class_10701.method_67169(world, pos))) effect.run(world, zombie, adversery);
  }

  @Override
  public MapCodec<? extends ZombieEffect> getCodec() {
    return CODEC;
  }
}
