package org.codeberg.zenxarch.zombies.entity.effect;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.jetbrains.annotations.Nullable;

public record RandomZombieEffect(List<ZombieEffect> effects, class_5863 chance)
    implements ZombieEffect {

  public static final MapCodec<RandomZombieEffect> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      class_5699.method_65313(ZombieEffect.CODEC)
                          .fieldOf("effects")
                          .forGetter(RandomZombieEffect::effects),
                      class_5863.field_29007
                          .optionalFieldOf("chance", class_5862.method_33908(1.0f))
                          .forGetter(RandomZombieEffect::chance))
                  .apply(instance, RandomZombieEffect::new));

  @Override
  public void run(
      class_3218 world, ExtendedZombieEntity zombie, @Nullable class_1309 adversery) {
    var random = zombie.method_59922();
    if (random.method_43058() >= chance.method_33920(random)) return;
    class_156.method_40083(effects, random)
        .ifPresent(effect -> effect.run(world, zombie, adversery));
  }

  @Override
  public MapCodec<RandomZombieEffect> getCodec() {
    return CODEC;
  }

  public static ZombieEffect create(ZombieEffect... effects) {
    if (effects.length == 0) return DefaultZombieEffect.create();
    if (effects.length == 1) return effects[0];
    return new RandomZombieEffect(List.of(effects), class_5862.method_33908(1.0f));
  }

  public static ZombieEffect create(class_5863 chance, ZombieEffect... effects) {
    if (effects.length == 0) return DefaultZombieEffect.create();
    return new RandomZombieEffect(List.of(effects), chance);
  }
}
