package org.codeberg.zenxarch.zombies.entity.effect;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.codeberg.zenxarch.zombies.entity.effect.single.SingleLivingEffect;
import org.jetbrains.annotations.Nullable;

public record SingleTargetZombieEffect(SingleLivingEffect effect, boolean targetZombie)
    implements ZombieEffect {

  public static final MapCodec<SingleTargetZombieEffect> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      SingleLivingEffect.CODEC
                          .fieldOf("effect")
                          .forGetter(SingleTargetZombieEffect::effect),
                      Codec.BOOL
                          .optionalFieldOf("targetZombie", true)
                          .forGetter(SingleTargetZombieEffect::targetZombie))
                  .apply(instance, SingleTargetZombieEffect::new));

  @Override
  public void run(
      class_3218 world, ExtendedZombieEntity zombie, @Nullable class_1309 adversery) {
    if (targetZombie) {
      effect.run(world, zombie);
    } else if (adversery != null) {
      effect.run(world, adversery);
    }
  }

  @Override
  public MapCodec<SingleTargetZombieEffect> getCodec() {
    return CODEC;
  }
}
