package org.codeberg.zenxarch.zombies.entity.effect;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.jetbrains.annotations.Nullable;

public record StatusEffectZombieEffect(List<class_1293> effects) implements ZombieEffect {

  public static final MapCodec<StatusEffectZombieEffect> CODEC =
      class_5699.method_65313(class_1293.field_48821)
          .xmap(StatusEffectZombieEffect::new, StatusEffectZombieEffect::effects)
          .fieldOf("effects");

  public StatusEffectZombieEffect(class_1293 effect) {
    this(List.of(effect));
  }

  @Override
  public void run(
      class_3218 world, ExtendedZombieEntity zombie, @Nullable class_1309 adversery) {
    if (adversery == null) return;
    var random = zombie.method_59922();
    var optionalEntry = class_156.method_40083(effects, random);
    if (optionalEntry.isPresent()) adversery.method_37222(optionalEntry.get(), zombie);
  }

  @Override
  public MapCodec<StatusEffectZombieEffect> getCodec() {
    return CODEC;
  }
}
