package org.codeberg.zenxarch.zombies.entity.effect;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.jetbrains.annotations.Nullable;

public record SwapPositionZombieEffect() implements ZombieEffect {
  private static final SwapPositionZombieEffect INSTANCE = new SwapPositionZombieEffect();
  public static final MapCodec<SwapPositionZombieEffect> CODEC = MapCodec.unit(INSTANCE);

  private static class_5454 getTeleportTarget(class_3218 world, class_1309 living) {
    return new class_5454(
        world,
        living.method_19538(),
        living.method_18798(),
        living.method_36454(),
        living.method_36455(),
        class_5454.field_52245);
  }

  @Override
  public void run(
      class_3218 world, ExtendedZombieEntity zombie, @Nullable class_1309 adversery) {
    if (adversery == null) return;

    var toAdversary = getTeleportTarget(world, adversery);
    var toZombie = getTeleportTarget(world, zombie);

    zombie.method_5731(toAdversary);
    adversery.method_5731(toZombie);
  }

  @Override
  public MapCodec<SwapPositionZombieEffect> getCodec() {
    return CODEC;
  }

  public static SwapPositionZombieEffect create() {
    return INSTANCE;
  }
}
