package org.codeberg.zenxarch.zombies.entity.effect;

import static net.minecraft.class_9734.*;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_9734;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.codeberg.zenxarch.zombies.entity.effect.single.FreezeEffect;
import org.codeberg.zenxarch.zombies.entity.effect.single.IgniteEffect;
import org.codeberg.zenxarch.zombies.entity.effect.single.SingleLivingEffect;
import org.codeberg.zenxarch.zombies.entity.effect.single.SpawnParticleEffect;
import org.codeberg.zenxarch.zombies.registry.ZombieRegistries;
import org.jetbrains.annotations.Nullable;

public interface ZombieEffect {
  public static final Codec<ZombieEffect> CODEC =
      Codec.withAlternative(
          ZombieRegistries.ZOMBIE_EFFECT
              .method_39673()
              .dispatch(ZombieEffect::getCodec, Function.identity()),
          DefaultZombieEffect.CODEC.codec());

  public void run(class_3218 world, ExtendedZombieEntity zombie, @Nullable class_1309 adversery);

  public MapCodec<? extends ZombieEffect> getCodec();

  public static void init() {
    register("default", DefaultZombieEffect.CODEC);
    register("all_of", AllOfZombieEffect.CODEC);
    register("random", RandomZombieEffect.CODEC);
    register("single_target", SingleTargetZombieEffect.CODEC);
    register("status_effect", StatusEffectZombieEffect.CODEC);
    register("swap_position", SwapPositionZombieEffect.CODEC);
    register("conditional", ConditionalSpawnEffect.CODEC);
  }

  private static void register(String id, MapCodec<? extends ZombieEffect> codec) {
    class_2378.method_10230(ZombieRegistries.ZOMBIE_EFFECT, Zombies.id(id), codec);
  }

  public static SwapPositionZombieEffect swapPositions() {
    return SwapPositionZombieEffect.create();
  }

  public static SingleTargetZombieEffect toPlayer(SingleLivingEffect effect) {
    return new SingleTargetZombieEffect(effect, false);
  }

  public static SingleTargetZombieEffect toZombie(SingleLivingEffect effect) {
    return new SingleTargetZombieEffect(effect, true);
  }

  public static SingleTargetZombieEffect ignite(float seconds) {
    return toPlayer(new IgniteEffect(seconds));
  }

  public static SingleTargetZombieEffect freeze() {
    return toPlayer(FreezeEffect.create());
  }

  public static ZombieEffect random(ZombieEffect... effect) {
    return RandomZombieEffect.create(effect);
  }

  public static ZombieEffect statusEffect(class_1293... builders) {
    if (builders.length == 0) return DefaultZombieEffect.create();
    return new StatusEffectZombieEffect(List.of(builders));
  }

  public static SingleTargetZombieEffect spawnParticles(
      class_2394 particle,
      class_9734.class_9735 horizontalPosition,
      class_9734.class_9735 verticalPosition,
      class_9734.class_9738 horizontalVelocity,
      class_9734.class_9738 verticalVelocity,
      class_5863 speed) {
    return toZombie(
        new SpawnParticleEffect(
            new class_9734(
                particle,
                horizontalPosition,
                verticalPosition,
                horizontalVelocity,
                verticalVelocity,
                speed)));
  }

  public static SingleTargetZombieEffect spawnParticles(class_2394 particle, float speed) {
    var floatProvider = class_5862.method_33908(speed);
    return spawnParticles(
        particle,
        method_60252(),
        method_60252(),
        method_60250(floatProvider),
        method_60250(floatProvider),
        floatProvider);
  }
}
