package org.codeberg.zenxarch.zombies.entity.effect.single;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.registry.ZombieRegistries;

public interface SingleLivingEffect {
  public static final Codec<SingleLivingEffect> CODEC =
      ZombieRegistries.SINGLE_LIVING_EFFECT_REGISTRY
          .method_39673()
          .dispatch(SingleLivingEffect::getCodec, Function.identity());

  public void run(class_3218 world, class_1309 target);

  public MapCodec<? extends SingleLivingEffect> getCodec();

  public static void init() {
    register("default", DefaultSingleLivingEffect.CODEC);
    register("freeze", FreezeEffect.CODEC);
    register("ignite", IgniteEffect.CODEC);
    register("spawn_effect_cloud", SpawnEffectCloudEffect.CODEC);
    register("spawn_particle_effect", SpawnParticleEffect.CODEC);
    register("apply_status_effect", StatusEffectLivingEffect.CODEC);
    register("default_attribute", DefaultAttributeEffect.CODEC);
    register("attribute_modifier", AttributeModifierEffect.CODEC);
  }

  private static void register(String id, MapCodec<? extends SingleLivingEffect> codec) {
    class_2378.method_10230(ZombieRegistries.SINGLE_LIVING_EFFECT_REGISTRY, Zombies.id(id), codec);
  }
}
