package org.codeberg.zenxarch.zombies.entity.effect.single;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_5699;

public record SpawnEffectCloudEffect(
    List<class_1293> effects,
    class_2394 particleEffect,
    float radius,
    float radiusOnUse)
    implements SingleLivingEffect {

  public static final MapCodec<SpawnEffectCloudEffect> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      class_5699.method_65320(
                              class_1293.field_48821,
                              class_1293.field_48821.listOf(1, Integer.MAX_VALUE))
                          .fieldOf("effects")
                          .forGetter(SpawnEffectCloudEffect::effects),
                      class_2398.field_25125
                          .fieldOf("particleEffect")
                          .forGetter(SpawnEffectCloudEffect::particleEffect),
                      class_5699.field_53754
                          .fieldOf("radius")
                          .forGetter(SpawnEffectCloudEffect::radius),
                      class_5699.field_53754
                          .fieldOf("radiusOnUse")
                          .forGetter(SpawnEffectCloudEffect::radiusOnUse))
                  .apply(instance, SpawnEffectCloudEffect::new));

  @Override
  public void run(class_3218 world, class_1309 target) {
    if (effects.isEmpty()) return;
    var cloud = new class_1295(world, target.method_23317(), target.method_23318(), target.method_23321());
    cloud.method_5603(radius);
    cloud.method_5609(radiusOnUse);
    cloud.method_5595(10);
    cloud.method_5604(cloud.method_5605() / 2);
    cloud.method_5596(-cloud.method_5599() / cloud.method_5605());

    cloud.method_5608(particleEffect);

    for (var effect : effects) cloud.method_5610(effect);

    world.method_8649(cloud);
  }

  @Override
  public MapCodec<SpawnEffectCloudEffect> getCodec() {
    return CODEC;
  }
}
