package org.codeberg.zenxarch.zombies.entity.effect.single;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_3218;
import net.minecraft.class_5699;

public record StatusEffectLivingEffect(List<class_1293> effects)
    implements SingleLivingEffect {
  public static final MapCodec<StatusEffectLivingEffect> CODEC =
      class_5699.method_65313(class_1293.field_48821)
          .xmap(StatusEffectLivingEffect::new, StatusEffectLivingEffect::effects)
          .fieldOf("effects");

  public StatusEffectLivingEffect(class_1293 effect) {
    this(List.of(effect));
  }

  @Override
  public void run(class_3218 world, class_1309 target) {
    var random = target.method_59922();
    var optionalEntry = class_156.method_40083(effects, random);
    if (optionalEntry.isPresent()) target.method_6092(optionalEntry.get());
  }

  @Override
  public MapCodec<StatusEffectLivingEffect> getCodec() {
    return CODEC;
  }
}
