package org.codeberg.zenxarch.zombies.loot_table;

import java.util.stream.Stream;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_219;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.class_85;
import org.codeberg.zenxarch.zombies.datagen.ZEnchantmentProviders;

public interface EquipmentLootTable {

  private static class_55.class_56 pool() {
    return class_55.method_347().method_352(class_44.method_32448(1.0f));
  }

  private static class_55.class_56 pool(class_1792 item) {
    return pool().method_351(class_77.method_411(item));
  }

  private static class_52.class_53 table(class_55.class_56... pools) {
    var result = class_52.method_324();
    for (var pool : pools) result = result.method_336(pool);
    return result;
  }

  private static class_52.class_53 entry(class_1304 slot, int level) {
    return table(pool(class_1308.method_5948(slot, level)));
  }

  private static class_85.class_86<?> entry(class_52.class_53 builder) {
    return class_83.method_57631(builder.method_338());
  }

  private static class_55.class_56 build(class_52.class_53 builder) {
    return pool().method_351(entry(builder).method_421(class_219.method_932(0.009f)));
  }

  private static class_52.class_53 getLootTableForLevel(int level) {
    final class_1304[] slots = {
      class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166
    };

    var entries = Stream.of(slots).map(slot -> entry(slot, level)).toList();

    return entries
        .get(0)
        .method_336(build(entries.get(1).method_336(build(entries.get(2).method_336(build(entries.get(3)))))));
  }

  private static class_79.class_80<?> applyEnchantment(class_52.class_53 builder, int weight) {
    var enchantment =
        new EnchantmentProviderLootFunction(ZEnchantmentProviders.ZOMBIE_SPAWN_EQUIPMENT);
    return entry(
            table(
                pool()
                    .method_351(entry(builder).method_437(200 * 1000))
                    .method_351(entry(builder.apply(enchantment)).method_437(0).method_436(1000))))
        .method_437(weight);
  }

  public static class_55.class_56 vanillaEquipmentTable() {
    final int[] equipmentLevel = {0, 1, 2, 3, 4};
    final int[] weights = {3706, 4873, 1290, 127, 4};
    var pool = class_55.method_347().method_352(class_44.method_32448(1.0f));
    for (var index : equipmentLevel)
      pool = pool.method_351(applyEnchantment(getLootTableForLevel(index), weights[index]));
    return pool.method_356(
        class_219.method_60310(LuckLootNumberProvider.create(0.0f, 0.15f)));
  }
}
