package org.codeberg.zenxarch.zombies.loot_table;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.SimpleFabricLootTableProvider;
import net.minecraft.class_173;
import net.minecraft.class_1802;
import net.minecraft.class_219;
import net.minecraft.class_52;
import net.minecraft.class_52.class_53;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_7225;
import net.minecraft.class_77;

public class ZLootTableProvider extends SimpleFabricLootTableProvider {

  public ZLootTableProvider(
      FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
    super(output, registryLookup, class_173.field_50217);
  }

  private static void addLootTable(
      BiConsumer<class_5321<class_52>, class_53> lootTableBiConsumer,
      class_5321<class_52> lootTable,
      class_55.class_56... lootPools) {
    var builder = class_52.method_324();
    for (var lootPool : lootPools) builder = builder.method_336(lootPool);
    lootTableBiConsumer.accept(lootTable, builder);
  }

  @Override
  public void method_10399(BiConsumer<class_5321<class_52>, class_53> registry) {
    addLootTable(
        registry,
        ZombieLootTables.COMMON_ZOMBIE_EQUIPMENT.comp_2621(),
        EquipmentLootTable.vanillaEquipmentTable(),
        class_55.method_347()
            .method_351(class_77.method_411(class_1802.field_8371))
            .method_351(class_77.method_411(class_1802.field_8699).method_437(2))
            .method_356(class_219.method_932(0.05f)));
  }
}
