package org.codeberg.zenxarch.zombies.registry;

import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7922;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.entity.effect.ZombieEffect;
import org.codeberg.zenxarch.zombies.entity.effect.single.SingleLivingEffect;
import org.codeberg.zenxarch.zombies.entity.variant.ZombieVariant;

public interface ZombieRegistries {

  private static <T> class_7922<MapCodec<? extends T>> createRegistry(
      class_5321<class_2378<MapCodec<? extends T>>> key) {
    return FabricRegistryBuilder.createDefaulted(key, Zombies.id("default")).buildAndRegister();
  }

  public static final class_7922<MapCodec<? extends SingleLivingEffect>>
      SINGLE_LIVING_EFFECT_REGISTRY = createRegistry(ZombieRegistryKeys.SINGLE_LIVING);

  public static final class_7922<MapCodec<? extends ZombieEffect>> ZOMBIE_EFFECT =
      createRegistry(ZombieRegistryKeys.ZOMBIE_EFFECT);

  public static void init() {
    ZombieEffect.init();
    SingleLivingEffect.init();
    DynamicRegistries.register(ZombieRegistryKeys.ZOMBIE_VARIANT, ZombieVariant.CODEC);
  }
}
