package org.codeberg.zenxarch.zombies.spawning;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.math.IntRange;

public final class SpawnProvider {
  private static final class_5819 random = class_5819.method_43047();
  private static final int SPAWN_RANGE = 80;
  private static final int SQ_NEARBY_RANGE = 16 * 16;

  private SpawnProvider() {
    throw new IllegalStateException("Utility class");
  }

  private static boolean isTooCloseToAny(class_2338 b, List<class_2338> positions) {
    for (var pos : positions) {
      var sqDist = pos.method_10262(b);
      if (sqDist < SQ_NEARBY_RANGE) return false;
    }
    return true;
  }

  private static Optional<class_2338> validate(
      class_3218 world, List<class_2338> positions, Optional<class_2338> pos) {
    return pos.filter(b -> isTooCloseToAny(b, positions))
        .filter(pz -> SpawnUtils.canSpawnAtPosBasic(world, pz));
  }

  private static boolean doesNotBlockMob(class_3218 world, class_2338 pos) {
    return world.method_8320(pos).method_26220(world, pos).method_1110();
  }

  private static boolean doesNotContainFluid(class_3218 world, class_2338 pos) {
    return world.method_8316(pos).method_15769();
  }

  private static Optional<class_2338> adjustPos(class_3218 world, class_2338 ipos, IntRange yRange) {
    var pos = ipos.method_25503();

    var blockLight = world.method_8314(class_1944.field_9282, pos);
    var ourRange = IntRange.of(blockLight, 16).shiftBy(pos.method_10264());
    ourRange = ourRange.intersection(yRange);

    if (!ourRange.isValid()) return Optional.empty();

    for (var y : ourRange.iterate()) {
      pos.method_33098(y + 1);
      if (!doesNotBlockMob(world, pos)) return Optional.of(pos.method_10084());
      if (!doesNotContainFluid(world, pos)) return Optional.empty();
    }

    return Optional.empty();
  }

  private static IntRange getSpawnRangeFor(int x, int z) {
    int sqDist = x * x + z * z;
    int radSq = SPAWN_RANGE * SPAWN_RANGE;
    if (sqDist >= radSq) return IntRange.INVALID;

    int y = class_3532.method_15384(Math.sqrt((double) radSq - sqDist));
    return IntRange.of(y);
  }

  private static IntRange getYRange(class_3218 world, class_2338 centerPos, class_2338 pos) {
    var range = SpawnUtils.getBounds(world, pos);

    int relx = centerPos.method_10263() - pos.method_10263();
    int relz = centerPos.method_10260() - pos.method_10260();
    var otherRange = getSpawnRangeFor(relx, relz);

    if (!otherRange.isValid()) return IntRange.INVALID;
    otherRange = otherRange.shiftBy(centerPos.method_10264());

    range = range.intersection(otherRange);

    return range;
  }

  public static Optional<class_2338> giveSpawnPositions(
      class_3218 world,
      class_2338 centerPos,
      List<class_2338> positions,
      Object2IntMap<class_2382> densityMap,
      int toSpawn) {
    var spawnTries =
        (toSpawn * 100) / (world.method_64395().method_8356(ZombieGamerules.SPAWN_SPEED) * 20);
    spawnTries = Math.max(spawnTries, 1);

    var maxDensity = ZombieDensityMap.getMaxDensity(toSpawn);

    for (var pos : class_2338.method_34848(random, spawnTries, centerPos, SPAWN_RANGE)) {
      if (SpawnUtils.burnsZombie(world, pos) || ZombieDensityMap.get(densityMap, pos) > maxDensity)
        continue;

      var adjustedPos = tryAdjustRandomPos(world, centerPos, pos);
      adjustedPos = validate(world, positions, adjustedPos);
      if (adjustedPos.isPresent()) return adjustedPos;
    }
    return Optional.empty();
  }

  private static Optional<class_2338> tryAdjustRandomPos(
      class_3218 world, class_2338 origin, class_2338 pos) {
    var range = getYRange(world, origin, pos);
    if (!range.isValid()) return Optional.empty();

    return adjustPos(world, pos, range);
  }
}
