package org.codeberg.zenxarch.zombies.spawning;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.difficulty.ExtendedDifficulty;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.codeberg.zenxarch.zombies.entity.variant.ZombieVariant;
import org.codeberg.zenxarch.zombies.registry.ZombieRegistryKeys;

public class ZombieApocalypse {
  private class_3218 world;
  private Object2IntMap<class_2382> zombieCount;

  public ZombieApocalypse(class_3218 world) {
    this.world = world;
  }

  private void spawnZombie(ExtendedZombieEntity zombie) {
    if (world.method_64395().method_8355(ZombieGamerules.ZOMBIE_TARGET_PLAYER_ON_SPAWN)) {
      zombie.method_5980(
          world.method_8604(
              zombie.method_23317(),
              zombie.method_23318(),
              zombie.method_23321(),
              64.0,
              class_1301.field_6157.and(
                  class_1301.field_6156)));
    }
    zombie.initialize(this.world);
    this.world.method_30771(zombie);
  }

  private Optional<ExtendedZombieEntity> createZombie(class_2338 pos) {
    var zombie = new ExtendedZombieEntity(world);
    zombie.method_5725(pos, world.field_9229.method_43057() * 360.0F, 0.0F);
    if (zombie.method_5957(world)) return Optional.of(zombie);
    return Optional.empty();
  }

  private void spawnZombie(class_3222 player, class_2338 pos, ExtendedDifficulty difficulty) {
    createZombie(pos).ifPresent(this::spawnZombie);
  }

  public void spawnZombiesNear(class_3222 player, List<class_2338> positions) {
    var difficulty = new ExtendedDifficulty(this.world, player.method_24515());
    var toSpawn = difficulty.getMaxZombies();

    var subMap = ZombieDensityMap.getSubMap(zombieCount, player.method_24515());
    var total = subMap.values().intStream().sum();
    if (toSpawn <= total) return;

    SpawnProvider.giveSpawnPositions(world, player.method_24515(), positions, subMap, toSpawn)
        .ifPresent(pos -> this.spawnZombie(player, pos, difficulty));
  }

  public Object2IntMap<class_2382> countZombies() {
    var result = new Object2IntArrayMap<class_2382>();
    for (var entity : world.method_27909()) {
      if (!(entity instanceof ExtendedZombieEntity zombie)) continue;
      ZombieDensityMap.push(result, zombie.method_24515());
    }
    return result;
  }

  public static List<class_3222> players(class_3218 world) {
    return world.method_18766(
        class_1301.field_6157.and(class_1301.field_6155));
  }

  private void debugCheck(Object2IntMap<class_2382> zombieCount) {
    for (var player : players(this.world)) {
      var pos = player.method_24515();
      var difficulty = (int) (new ExtendedDifficulty(world, pos).method_5458() * 100);
      var zcount = ZombieDensityMap.getSubMap(zombieCount, pos).values().intStream().sum();
      player.method_7353(class_2561.method_30163(difficulty + " : " + zcount), true);
    }
  }

  public void spawn(class_3218 world, boolean spawnMonsters) {
    this.world = world;
    if (!spawnMonsters
        || this.world.method_8407().equals(class_1267.field_5801)
        || !this.world.method_64395().method_8355(ZombieGamerules.DO_ZOMBIE_SPAWNING)) {
      return;
    }

    var players = players(world);
    var positions = players.stream().map(class_3222::method_24515).toList();
    this.zombieCount = countZombies();

    if (FabricLoader.getInstance().isDevelopmentEnvironment()) debugCheck(this.zombieCount);

    for (var player : players) {
      spawnZombiesNear(player, positions);
    }
  }

  public static boolean isApocalypticWorld(class_3218 world) {
    if (world.method_27983().equals(class_1937.field_25179)) return true;
    return false;
  }

  public static final String ZOMBIE_ID_KEY = "zenxarch_zombie_id";

  private static class_2960 toId(String id) {
    int i = id.indexOf(":");
    if (i >= 0) {
      String string = id.substring(i + 1);
      if (i != 0) {
        String string2 = id.substring(0, i);
        return class_2960.method_60655(string2, string);
      }
      return Zombies.id(string);
    }
    return Zombies.id(id);
  }

  private static Optional<class_6880<ZombieVariant>> fromId(class_1937 world, class_2960 id) {
    return world
        .method_30349()
        .method_30530(ZombieRegistryKeys.ZOMBIE_VARIANT)
        .method_10223(id)
        .map(Function.identity());
  }

  public static Optional<class_6880<ZombieVariant>> getVariantFromNbt(
      class_1937 world, class_2487 nbt) {
    var idKey = nbt.getString(ZOMBIE_ID_KEY);
    if (idKey.isEmpty()) return Optional.empty();
    return switch (idKey.get()) {
      case "" -> Optional.empty();
      case String id -> {
        try {
          yield fromId(world, toId(id));
        } catch (Exception e) {
          Zombies.LOGGER.info("Exception caught: {}", e.getMessage());
          yield Optional.empty();
        }
      }
    };
  }

  public static Optional<class_1297> loadFromNbt(class_2487 nbt, class_1937 world) {
    return getVariantFromNbt(world, nbt).map(variant -> loadFromVariant(world, variant, nbt));
  }

  private static ExtendedZombieEntity loadFromVariant(
      class_1937 world, class_6880<ZombieVariant> variant, class_2487 nbt) {
    var result = new ExtendedZombieEntity(world);
    result.method_5651(nbt);
    return result;
  }
}
