package org.codeberg.zenxarch.zombies.spawning;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public final class ZombieDensityMap {

  private ZombieDensityMap() {
    throw new IllegalStateException("Utility class");
  }

  private static final int BOX_SIZE = 24;
  private static final int MAX_DISTANCE_FROM_CENTER = 3;

  private static int round(int v) {
    return v / BOX_SIZE;
  }

  private static class_2382 round(class_2338 pos) {
    var x = round(pos.method_10263());
    var y = round(pos.method_10264());
    var z = round(pos.method_10260());
    return new class_2382(x, y, z);
  }

  public static void push(Object2IntMap<class_2382> map, class_2338 element) {
    var key = round(element);
    map.put(key, map.getOrDefault(key, 0) + 1);
  }

  public static Object2IntMap<class_2382> getSubMap(Object2IntMap<class_2382> map, class_2338 pos) {
    var result = new Object2IntArrayMap<class_2382>();
    for (var key : map.keySet()) if (isWithinDistance(key, pos)) result.put(key, map.getInt(key));
    return result;
  }

  public static int get(Object2IntMap<class_2382> map, class_2338 pos) {
    return map.getInt(round(pos));
  }

  private static boolean isWithinDistance(class_2382 box, class_2338 pos) {
    var mapped = round(pos);
    return isWithinDistance(box.method_10263(), mapped.method_10263())
        && isWithinDistance(box.method_10264(), mapped.method_10264())
        && isWithinDistance(box.method_10260(), mapped.method_10260());
  }

  private static boolean isWithinDistance(int a, int b) {
    return Math.abs(a - b) <= MAX_DISTANCE_FROM_CENTER;
  }

  public static int getMaxDensity(int toSpawn) {
    return Math.max(toSpawn / 49, 1) * 8;
  }
}
