package org.codeberg.zenxarch.mob_variants_api.variant.effect.pair;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.MobEffect;
import org.jetbrains.annotations.Nullable;

public record IntervalMobEffect(int ticks, MobEffect effect) implements MobEffect {

  public static final MapCodec<IntervalMobEffect> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      class_5699.field_33442.fieldOf("ticks").forGetter(IntervalMobEffect::ticks),
                      MobEffect.CODEC.fieldOf("effect").forGetter(IntervalMobEffect::effect))
                  .apply(instance, IntervalMobEffect::new));

  @Override
  public void run(class_3218 world, class_1308 mob, @Nullable class_1309 adversery) {
    if (world.method_75260() % ticks == 0) effect.run(world, mob, adversery);
  }

  @Override
  public MapCodec<? extends MobEffect> getCodec() {
    return CODEC;
  }
}
