package org.codeberg.zenxarch.mob_variants_api.variant.effect.pair;

import com.mojang.serialization.MapCodec;
import java.lang.reflect.Constructor;
import net.minecraft.class_10179;
import net.minecraft.class_10181;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.MobEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SplitSelfMobEffect() implements MobEffect {

  public static final SplitSelfMobEffect INSTANCE = new SplitSelfMobEffect();
  public static final MapCodec<SplitSelfMobEffect> CODEC = MapCodec.unit(INSTANCE);

  @Override
  public void run(class_3218 world, class_1308 mob, @Nullable class_1309 adversery) {
    var instance = mob.method_5996(class_5134.field_23716);
    if (instance.method_6201() <= 1) return;

    instance.method_6192(instance.method_6201() / 2);
    mob.method_6033(mob.method_6063());

    var newMob = summonSplitMob(world, mob, instance.method_6201());
    if (newMob == null) return;

    if (mob.method_29504()) summonSplitMob(world, mob, instance.method_6201());
  }

  private static class_1308 summonSplitMob(class_3218 world, class_1308 oldMob, double maxHealth) {
    var newMob = createEntityOfSameClass(world, oldMob);
    if (newMob == null) return null;

    var context =
        new class_10179(
            class_10181.field_54081, true, true, oldMob.method_5781());
    context.comp_3144().method_63609(oldMob, newMob, context);
    world.method_8649(newMob);

    newMob.method_5996(class_5134.field_23716).method_6192(maxHealth);

    newMob.method_6033(newMob.method_6063());
    newMob.method_5808(
        oldMob.method_23317(), oldMob.method_23318(), oldMob.method_23321(), oldMob.method_36454(), oldMob.method_36455());
    return newMob;
  }

  private static class_1308 createEntityOfSameClass(class_3218 world, class_1308 mob) {
    Constructor<? extends class_1308> constructor;
    try {
      constructor = mob.getClass().getConstructor(class_1937.class);
      return constructor.newInstance(world);
    } catch (Exception e) {
      try {
        constructor = mob.getClass().getConstructor(class_1299.class, class_1937.class);
        return constructor.newInstance(mob.method_5864(), world);
      } catch (Exception ex) {
        return null;
      }
    }
  }

  @Override
  public @NotNull MapCodec<? extends MobEffect> getCodec() {
    return CODEC;
  }
}
