package org.codeberg.zenxarch.mob_variants_api.variant.effect.pair;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.MobEffect;
import org.jetbrains.annotations.Nullable;

public record StatusMobEffect(List<class_1293> effects) implements MobEffect {

  public static final MapCodec<StatusMobEffect> CODEC =
      class_5699.method_65313(class_1293.field_48821)
          .xmap(StatusMobEffect::new, StatusMobEffect::effects)
          .fieldOf("effects");

  public StatusMobEffect(class_1293 effect) {
    this(List.of(effect));
  }

  @Override
  public void run(class_3218 world, class_1308 mob, @Nullable class_1309 adversery) {
    if (adversery == null) return;
    var random = mob.method_59922();
    var optionalEntry = class_156.method_40083(effects, random);
    if (optionalEntry.isPresent()) adversery.method_37222(optionalEntry.get(), mob);
  }

  @Override
  public MapCodec<StatusMobEffect> getCodec() {
    return CODEC;
  }
}
