/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies;

import net.fabricmc.fabric.api.gamerule.v1.GameRuleBuilder;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleEvents;
import net.minecraft.class_12279;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5198;
import net.minecraft.server.MinecraftServer;
import org.codeberg.zenxarch.zombies.ZombieHealth;
import org.codeberg.zenxarch.zombies.Zombies;

public final class ZombieGamerules {
    public static final class_5198 ZOMBIES_GENERAL = class_5198.method_76160((class_2960)Zombies.id("zombies_general"));
    public static final class_5198 ZOMBIES_HEARTS = class_5198.method_76160((class_2960)Zombies.id("zombies_hearts"));
    public static final class_12279<Integer> MAX_ZOMBIES = ZombieGamerules.newGameRule("max_zombies", ZOMBIES_GENERAL, 150, 0);
    public static final class_12279<Integer> SPAWN_SPEED = ZombieGamerules.newGameRule("fill_zombie_cap_over_seconds", ZOMBIES_GENERAL, 30, 1);
    public static final class_12279<Boolean> ZOMBIES_BURN_IN_DAYLIGHT = ZombieGamerules.newGameRule("zombies_burn_in_daylight", ZOMBIES_GENERAL, false);
    public static final class_12279<Boolean> DO_ZOMBIE_SPAWNING = ZombieGamerules.newGameRule("do_zombie_spawning", ZOMBIES_GENERAL, true);
    public static final class_12279<Boolean> ZOMBIE_TARGET_PLAYER_ON_SPAWN = ZombieGamerules.newGameRule("zombie_target_player_on_spawn", ZOMBIES_GENERAL, false);
    public static final class_12279<Boolean> DO_ZOMBIE_KILLS_BASED_HEARTS = ZombieGamerules.newGameRule("do_zombie_kills_based_hearts", ZOMBIES_HEARTS, false);
    public static final class_12279<Integer> ZOMBIE_KILLS_FOR_MAX_HEARTS = ZombieGamerules.newGameRule("zombie_kills_for_max_hearts", ZOMBIES_HEARTS, 2500, 1);
    public static final class_12279<Integer> MIN_HEARTS = ZombieGamerules.newGameRule("zombies.min_hearts", ZOMBIES_HEARTS, 3, 1);
    public static final class_12279<Integer> MAX_HEARTS = ZombieGamerules.newGameRule("zombies.max_hearts", ZOMBIES_HEARTS, 25, 1);

    private ZombieGamerules() {
        throw new IllegalStateException("Utility class");
    }

    private static class_12279<Integer> newGameRule(String name, class_5198 category, int defaultValue, int min) {
        return GameRuleBuilder.forInteger((int)defaultValue).minValue(Integer.valueOf(min)).category(category).buildAndRegister(Zombies.id(name));
    }

    private static class_12279<Boolean> newGameRule(String name, class_5198 category, boolean defaultValue) {
        return GameRuleBuilder.forBoolean((boolean)defaultValue).category(ZOMBIES_GENERAL).buildAndRegister(Zombies.id(name));
    }

    public static <T> void updateAllPlayers(T value, MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            for (class_3222 player : world.method_18456()) {
                ZombieHealth.updatePlayerStats(world, player);
            }
        }
    }

    public static void initialize() {
        GameRuleEvents.changeCallback(DO_ZOMBIE_KILLS_BASED_HEARTS).register(ZombieGamerules::updateAllPlayers);
    }
}

