/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.difficulty.category;

import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.difficulty.CachedValue;
import org.codeberg.zenxarch.zombies.difficulty.DifficultyCategory;
import org.codeberg.zenxarch.zombies.difficulty.ItemAttributeUtils;
import org.codeberg.zenxarch.zombies.difficulty.entry.CachedPlayerBasedDifficultyEntry;

public interface PlayerCategory {
    public static final AttachmentType<CachedValue> WEAPON_DAMAGE = PlayerCategory.createCache("player/weapon_damage");
    public static final AttachmentType<CachedValue> DAMAGE_PER_SECOND = PlayerCategory.createCache("player/damage_per_second");
    public static final AttachmentType<CachedValue> FOOD = PlayerCategory.createCache("player/food");
    public static final AttachmentType<CachedValue> ARMOR = PlayerCategory.createCache("player/armor");
    public static final CachedPlayerBasedDifficultyEntry WEAPON_DAMAGE_ENTRY = new CachedPlayerBasedDifficultyEntry(WEAPON_DAMAGE, PlayerCategory::weaponDamageScore, 1);
    public static final CachedPlayerBasedDifficultyEntry DAMAGE_PER_SECOND_ENTRY = new CachedPlayerBasedDifficultyEntry(DAMAGE_PER_SECOND, PlayerCategory::weaponDamagePerSecondScore, 1);
    public static final CachedPlayerBasedDifficultyEntry FOOD_ENTRY = new CachedPlayerBasedDifficultyEntry(FOOD, PlayerCategory::foodScore, 1);
    public static final CachedPlayerBasedDifficultyEntry ARMOR_ENTRY = new CachedPlayerBasedDifficultyEntry(ARMOR, PlayerCategory::armorScore, 1);
    public static final class_2960 PLAYER_CATEGORY = Zombies.id("player");

    private static AttachmentType<CachedValue> createCache(String id) {
        return CachedValue.createAttachmentType(Zombies.id(id));
    }

    public static void initialize() {
        DifficultyCategory.addDifficultyEntry(PLAYER_CATEGORY, WEAPON_DAMAGE_ENTRY);
        DifficultyCategory.addDifficultyEntry(PLAYER_CATEGORY, DAMAGE_PER_SECOND_ENTRY);
        DifficultyCategory.addDifficultyEntry(PLAYER_CATEGORY, FOOD_ENTRY);
        DifficultyCategory.addDifficultyEntry(PLAYER_CATEGORY, ARMOR_ENTRY);
    }

    private static double normalize(double value, double start, double end) {
        return class_3532.method_32854((double)value, (double)start, (double)end, (double)0.0, (double)1.0);
    }

    private static double weaponDamageScore(class_3218 world, class_3222 player) {
        return PlayerCategory.scoreWeapon(player, PlayerCategory::getAttackDamage, class_1802.field_8406, class_1802.field_22025);
    }

    private static double weaponDamagePerSecondScore(class_3218 world, class_3222 player) {
        return PlayerCategory.scoreWeapon(player, PlayerCategory::getDamagePerSecond, class_1802.field_8091, class_1802.field_22022);
    }

    private static double foodScore(class_3218 world, class_3222 player) {
        return PlayerCategory.items(player).mapToDouble(PlayerCategory::scoreFood).sum();
    }

    private static double armorScore(class_3218 world, class_3222 player) {
        return PlayerCategory.normalize(player.method_45325(class_5134.field_23724) + player.method_45325(class_5134.field_23725) + player.method_45325(class_5134.field_23718), 0.0, 32.0);
    }

    private static Stream<class_1799> items(class_3222 player) {
        return player.method_31548().method_67533().stream();
    }

    private static double getAttackDamage(class_1799 stack) {
        return ItemAttributeUtils.getAttributeValue((class_1299<? extends class_1309>)class_1299.field_6097, stack, (class_6880<class_1320>)class_5134.field_23721);
    }

    private static double getAttackSpeed(class_1799 stack) {
        return ItemAttributeUtils.getAttributeValue((class_1299<? extends class_1309>)class_1299.field_6097, stack, (class_6880<class_1320>)class_5134.field_23723);
    }

    private static double getDamagePerSecond(class_1799 stack) {
        return PlayerCategory.getAttackDamage(stack) * PlayerCategory.getAttackSpeed(stack);
    }

    private static double scoreFood(class_1799 stack) {
        double score = 0.0;
        if (stack.method_57353().method_57832(class_9334.field_50075)) {
            score = (double)((class_4174)stack.method_58694(class_9334.field_50075)).comp_2491() * (double)stack.method_7947();
        }
        return PlayerCategory.normalize(score, 0.0, 400.0);
    }

    private static boolean isAWeapon(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_57353().method_57832(class_9334.field_49636)) {
            return true;
        }
        return stack.method_7942();
    }

    private static double scoreWeapon(class_3222 player, ToDoubleFunction<class_1799> scorer, class_1792 minItem, class_1792 maxItem) {
        double baseMin = scorer.applyAsDouble(minItem.method_7854());
        double baseMax = scorer.applyAsDouble(maxItem.method_7854());
        double bestScore = PlayerCategory.items(player).filter(PlayerCategory::isAWeapon).mapToDouble(scorer).max().orElse(0.0);
        return PlayerCategory.normalize(bestScore, baseMin, baseMax);
    }
}

