/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.spawning;

import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import org.codeberg.zenxarch.zombies.ZombieGamerules;
import org.codeberg.zenxarch.zombies.data.ZBiomeTags;
import org.codeberg.zenxarch.zombies.math.IntRange;

public final class SpawnUtils {
    private SpawnUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean burnsZombie(class_3218 world, class_2338 pos) {
        return (Boolean)world.method_64395().method_76185(ZombieGamerules.ZOMBIES_BURN_IN_DAYLIGHT) != false && world.method_8530() && world.method_8311(pos);
    }

    public static IntRange getBounds(class_3218 world, int x, int z) {
        return IntRange.of(world.method_31607(), world.method_8624(class_2902.class_2903.field_13203, x, z));
    }

    public static IntRange getBounds(class_3218 world, class_2338 pos) {
        return SpawnUtils.getBounds(world, pos.method_10263(), pos.method_10260());
    }

    private static boolean doesPosAllowSpawning(class_3218 world, class_2338 pos) {
        if (SpawnUtils.burnsZombie(world, pos)) {
            return false;
        }
        if (world.method_8314(class_1944.field_9282, pos) > 0) {
            return false;
        }
        if (world.method_23753(pos).method_40220(ZBiomeTags.WITHOUT_ZOMBIE_APOCALYPSE)) {
            return false;
        }
        return class_1317.method_56558((class_1299)class_1299.field_6051, (class_4538)world, (class_2338)pos);
    }

    private static boolean doesEntityCollide(class_3218 world, class_243 pos) {
        class_238 boundingBox = class_1299.field_6051.method_58629(pos.method_10216(), pos.method_10214(), pos.method_10215());
        return !world.method_22345(boundingBox) && world.method_18026(boundingBox) && world.method_8611(null, class_259.method_1078((class_238)boundingBox));
    }

    public static boolean canSpawnAtPosBasic(class_3218 world, class_2338 pos) {
        if (!SpawnUtils.doesPosAllowSpawning(world, pos)) {
            return false;
        }
        class_243 spawnPos = pos.method_61082();
        return SpawnUtils.doesEntityCollide(world, spawnPos);
    }
}

