package org.codeberg.zenxarch.mob_variants_api.registry;

import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7922;
import org.codeberg.zenxarch.mob_variants_api.MobVariantsApiMod;
import org.codeberg.zenxarch.mob_variants_api.variant.MobVariant;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.LivingEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.MobEffect;

public interface MobRegisteries {

  private static <T> class_7922<MapCodec<? extends T>> createRegistry(
      class_5321<class_2378<MapCodec<? extends T>>> key) {
    return FabricRegistryBuilder.createDefaulted(key, MobVariantsApiMod.id("default"))
        .buildAndRegister();
  }

  public static final class_7922<MapCodec<? extends LivingEffect>> LIVING_EFFECT =
      createRegistry(MobRegistryKeys.LIVING_EFFECT);

  public static final class_7922<MapCodec<? extends MobEffect>> MOB_EFFECT =
      createRegistry(MobRegistryKeys.MOB_EFFECT);

  public static void init() {
    MobEffect.init();
    LivingEffect.init();
    DynamicRegistries.register(MobRegistryKeys.MOB_VARIANT, MobVariant.CODEC);
  }
}
