package org.codeberg.zenxarch.mob_variants_api.variant.effect.pair;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.LivingEffect;
import org.codeberg.zenxarch.mob_variants_api.variant.effect.MobEffect;
import org.jetbrains.annotations.Nullable;

public record SingleMobEffect(LivingEffect effect, boolean forSelf) implements MobEffect {

  public static final MapCodec<SingleMobEffect> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      LivingEffect.CODEC.fieldOf("effect").forGetter(SingleMobEffect::effect),
                      Codec.BOOL
                          .optionalFieldOf("forSelf", true)
                          .forGetter(SingleMobEffect::forSelf))
                  .apply(instance, SingleMobEffect::new));

  @Override
  public void run(class_3218 world, class_1308 mob, @Nullable class_1309 adversery) {
    if (forSelf) {
      effect.run(world, mob);
    } else if (adversery != null) {
      effect.run(world, adversery);
    }
  }

  @Override
  public MapCodec<SingleMobEffect> getCodec() {
    return CODEC;
  }
}
