/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.zombies.brain;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1439;
import net.minecraft.class_1481;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.AvoidSun;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.ReactToUnreachableTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.EscapeSun;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.InteractWithDoor;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.GenericAttackTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.codeberg.zenxarch.zombies.brain.LeapAtUnreachableTargetBehaviour;

public class ZombieBrain<T extends class_1642> {
    public class_4095.class_5303<?> getBrainProfile(T self) {
        return new SmartBrainProvider(self);
    }

    private boolean shouldTargetEntity(class_1309 living, T zombie) {
        if (!zombie.method_18395(living)) {
            return false;
        }
        class_1309 class_13092 = living;
        Objects.requireNonNull(class_13092);
        class_1309 class_13093 = class_13092;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1481.class}, (Object)class_13093, n)) {
            case 0 -> {
                class_1481 turtle = (class_1481)class_13093;
                if (turtle.method_6109() && !turtle.method_5799()) {
                    yield true;
                }
                yield false;
            }
            default -> living instanceof class_1657 || living instanceof class_3988 || living instanceof class_1439;
        };
    }

    public List<ExtendedSensor<T>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((x$0, x$1) -> this.shouldTargetEntity((class_1309)x$0, (Object)((class_1642)x$1))), new HurtBySensor().setPredicate((source, living) -> !(living instanceof class_1642)), new GenericAttackTargetSensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<T> getCoreTasks(Predicate<T> burnsInDaylight) {
        return BrainActivityGroup.coreTasks((class_4097[])new class_4097[]{new AvoidSun().startCondition(burnsInDaylight), new EscapeSun().speedModifier(1.5f).startCondition(burnsInDaylight).cooldownFor(zombie -> 20), new InteractWithDoor(), new LookAtAttackTarget().runFor(zombie -> zombie.method_59922().method_39332(40, 300)), new WalkOrRunToWalkTarget()});
    }

    public BrainActivityGroup<T> getIdleTasks() {
        return BrainActivityGroup.idleTasks((class_4097[])new class_4097[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((a, b) -> b instanceof class_1657).cooldownFor(z -> 20), new SetPlayerLookTarget(), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget(), new Idle().runFor(zombie -> zombie.method_59922().method_39332(30, 60))})});
    }

    public BrainActivityGroup<T> getFightTasks() {
        return BrainActivityGroup.fightTasks((class_4097[])new class_4097[]{new InvalidateAttackTarget(), new TargetOrRetaliate().alertAlliesWhen((a, b) -> b instanceof class_1657).cooldownFor(z -> 20), new SetWalkTargetToAttackTarget().speedMod(1.25f), new AnimatableMeleeAttack(0).whenStarting(zombie -> zombie.method_19540(true)).whenStopping(zombie -> zombie.method_19540(false)), new LeapAtUnreachableTargetBehaviour(0).whenStarting(zombie -> zombie.method_19540(true)).whenStopping(zombie -> zombie.method_19540(false)), new ReactToUnreachableTarget().reaction(ZombieBrain::rideFlyingMobs)});
    }

    public class_1408 createNavigation(T self, class_1937 world) {
        SmoothGroundNavigation navigation = new SmoothGroundNavigation(self, world);
        navigation.method_70687(true);
        return navigation;
    }

    public static void rideFlyingMobs(class_1309 self, boolean towering) {
        if (!towering) {
            return;
        }
        Optional<class_1309> nearestFlyingEntityOpt = ZombieBrain.findFlyingEntity(self);
        if (nearestFlyingEntityOpt.isEmpty()) {
            return;
        }
        class_1309 nearestFlyingEntity = nearestFlyingEntityOpt.get();
        if (self.method_5858((class_1297)nearestFlyingEntity) > (double)class_3532.method_34954((int)3)) {
            return;
        }
        self.method_5804((class_1297)nearestFlyingEntity);
    }

    private static Optional<class_1309> findFlyingEntity(class_1309 self) {
        return EntityRetrievalUtil.findEntity((class_1297)self, (double)10.0, e -> ZombieBrain.isRideable(e.method_5864()));
    }

    private static boolean isRideable(class_1299<?> type) {
        return type.equals((Object)class_1299.field_6104) || type.equals((Object)class_1299.field_6132);
    }
}

