package org.codeberg.zenxarch.zombies.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10086;
import net.minecraft.class_11659;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_5601;
import net.minecraft.class_623;
import org.codeberg.zenxarch.mob_variants_api.variant.OverlayAttachment;

public class ExtendedZombieEntityOverlayRenderer
    extends class_3887<class_10086, class_623<class_10086>> {
  private static Map<class_5601, Optional<class_623<class_10086>>>
      MODEL_CACHE = new HashMap<>();

  public ExtendedZombieEntityOverlayRenderer(
      class_3883<class_10086, class_623<class_10086>>
          context) {
    super(context);
  }

  private Optional<class_623<class_10086>> addModelToCache(
      OverlayAttachment overlay) {
    var layer = OverlayClient.getEntityModelLayer(overlay);
    if (MODEL_CACHE.containsKey(layer)) return MODEL_CACHE.get(layer);

    class_623<class_10086> model = null;
    try {
      var loader = class_310.method_1551().method_31974();
      model = new class_623<>(loader.method_32072(layer));
    } catch (Exception e) {
    }
    var result = Optional.ofNullable(model);
    MODEL_CACHE.put(layer, result);
    return result;
  }

  @Override
  public void render(
      class_4587 matrices,
      class_11659 queue,
      int light,
      class_10086 state,
      float limbAngle,
      float limbDistance) {
    var overlay = ExtendedZombieEntityRenderer.OVERLAY.get(state);
    if (overlay.isEmpty()) return;
    var model = addModelToCache(overlay.get());
    if (model.isEmpty()) return;
    method_23196(
        model.get(), overlay.get().texture().comp_3627(), matrices, queue, light, state, -1, 1);
  }
}
