package org.codeberg.zenxarch.zombies.client.debughud;

import net.minecraft.class_11630;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.difficulty.DifficultyCategory;
import org.codeberg.zenxarch.zombies.difficulty.ExtendedDifficulty;
import org.codeberg.zenxarch.zombies.difficulty.category.TimeCategory;
import org.jetbrains.annotations.Nullable;

public class ExtendedDifficultyDebugHudEntry implements ZombieDebugHudEntry {

  @Override
  public void method_72751(
      class_11630 lines,
      @Nullable class_1937 world,
      @Nullable class_2818 clientChunk,
      @Nullable class_2818 chunk) {
    if (world == null) return;
    if (!(world instanceof class_3218 serverWorld)) return;
    var player = class_310.method_1551().field_1724;
    if (player == null) return;
    var pos = player.method_24515();
    if (chunk == null || !world.method_62871(pos.method_10264())) return;
    var difficulty = new ExtendedDifficulty(serverWorld, pos);

    addLine(
        lines,
        String.format(
            "Extended Difficulty: %.2f // %.2f (Day %d,Hour %.1f)",
            difficulty.method_5457(),
            difficulty.method_5458(),
            (int) TimeCategory.getDays(serverWorld),
            TimeCategory.getHoursInhabited(serverWorld, chunk)));

    for (var category : DifficultyCategory.getCategories())
      addLine(
          lines,
          String.format(
              "Difficulty Category id: %s // %.2f",
              category, DifficultyCategory.calculateDifficulty(serverWorld, chunk, category)));
  }
}
