package org.codeberg.zenxarch.zombies.difficulty;

import java.util.function.BiFunction;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public record CachedValue(double value, long lastUpdated) {
  public static <T extends AttachmentTarget> double getOrUpdateValue(
      class_3218 world,
      T target,
      AttachmentType<CachedValue> attachment,
      BiFunction<class_3218, T, Double> value) {
    var time = world.method_8510();
    var attached =
        target.getAttachedOrCreate(
            attachment, () -> new CachedValue(value.apply(world, target), world.method_8510()));
    if (attached.lastUpdated >= time) return attached.value;
    var newValue = value.apply(world, target);
    target.setAttached(attachment, new CachedValue(newValue, time));
    return newValue;
  }

  public static AttachmentType<CachedValue> createAttachmentType(class_2960 id) {
    return AttachmentRegistry.create(id.method_45138("cache/"));
  }
}
