package org.codeberg.zenxarch.zombies.spawning;

import java.util.List;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.Zombies;

public final class SpawnerAttachments {
  private SpawnerAttachments() {
    throw new IllegalStateException("Utility class");
  }

  public static final AttachmentType<List<ZombieApocalypse>> ZOMBIE_APOCALYPSE =
      AttachmentRegistry.create(Zombies.id("zombie_apocalypse"));

  public static List<ZombieApocalypse> getApocalypses(class_3218 world) {
    return world.getAttachedOrSet(
        ZOMBIE_APOCALYPSE,
        ZombieApocalypse.isApocalypticWorld(world)
            ? List.of(new ZombieApocalypse(world))
            : List.of());
  }

  public static void initialize() {
    // force load class
  }
}
