package org.codeberg.zenxarch.zombies.spawning.provider;

import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.codeberg.zenxarch.zombies.math.IntRange;
import org.codeberg.zenxarch.zombies.spawning.SpawnUtils;

@FunctionalInterface
public interface PosRangeProvider {
  static final int SPAWN_RANGE = 80;

  public IntRange get(class_3218 world, class_2338 pos, class_2338 centerPos);

  public static final PosRangeProvider ZERO_BLOCKLIGHT =
      (world, pos, center) -> {
        var mutable = pos.method_25503();
        while (mutable.method_10264() >= (pos.method_10264() - 16)) {
          if (world.method_8314(class_1944.field_9282, mutable) >= 2) mutable.method_10104(class_2350.field_11033, 2);
          else if (world.method_8314(class_1944.field_9282, mutable) == 1) mutable.method_10098(class_2350.field_11033);
          else break;
        }

        var startY = mutable.method_10264();
        while (mutable.method_10264() >= (pos.method_10264() - 16)
            && world.method_8314(class_1944.field_9282, mutable) == 0) mutable.method_10098(class_2350.field_11033);

        return IntRange.of(mutable.method_10264(), startY);
      };

  public static final PosRangeProvider AROUND_CENTER =
      (world, pos, center) -> {
        int relx = center.method_10263() - pos.method_10263();
        int relz = center.method_10260() - pos.method_10260();
        var result = getSpawnRangeFor(relx, relz);

        if (!result.isValid()) return IntRange.INVALID;
        result = result.shiftBy(center.method_10264());
        return result;
      };

  public static final PosRangeProvider HEIGHTMAP_BOUNDS =
      (world, pos, center) -> SpawnUtils.getBounds(world, pos);

  private static IntRange getSpawnRangeFor(int x, int z) {
    int sqDist = x * x + z * z;
    int radSq = SPAWN_RANGE * SPAWN_RANGE;
    if (sqDist >= radSq) return IntRange.INVALID;

    int y = class_3532.method_15384(Math.sqrt((double) radSq - sqDist));
    return IntRange.of(y);
  }
}
