package org.codeberg.zenxarch.zombies.client;

import java.util.Objects;
import net.minecraft.class_10086;
import net.minecraft.class_11659;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_623;
import org.codeberg.zenxarch.mob_variants_api.variant.OverlayAttachment;

public class ExtendedZombieEntityOverlayRenderer
    extends class_3887<class_10086, class_623<class_10086>> {
  private class_2960 texture;
  private class_623<class_10086> model;
  private OverlayAttachment overlay;

  public ExtendedZombieEntityOverlayRenderer(
      class_3883<class_10086, class_623<class_10086>>
          context) {
    super(context);
    this.overlay = null;
  }

  private void setOverlay(OverlayAttachment overlay) {
    this.overlay = overlay;
    if (this.overlay == null) return;
    this.texture = this.overlay.texture().comp_3627();
    try {
      var loader = class_310.method_1551().method_31974();
      this.model =
          new class_623<>(
              loader.method_32072(OverlayClient.getEntityModelLayer(this.overlay)));
    } catch (Exception e) {
      this.model = null;
    }
  }

  @Override
  public void render(
      class_4587 matrices,
      class_11659 queue,
      int light,
      class_10086 state,
      float limbAngle,
      float limbDistance) {
    if (state instanceof ExtendedZombieEntityRenderState exstate
        && !Objects.equals(exstate.overlay, this.overlay)) {
      this.setOverlay(exstate.overlay);
    }
    if (this.overlay == null) return;
    if (this.model == null) return;
    method_23196(this.model, this.texture, matrices, queue, light, state, -1, 1);
  }
}
