package org.codeberg.zenxarch.zombies.loot_table.number_provider;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_3532;
import net.minecraft.class_47;
import net.minecraft.class_5657;
import net.minecraft.class_5658;

public record LuckLootNumberProvider(float min, float max) implements class_5658 {
  private static final LuckLootNumberProvider INSTANCE = new LuckLootNumberProvider(0.0F, 1.0F);
  public static final MapCodec<LuckLootNumberProvider> CODEC =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      Codec.FLOAT
                          .optionalFieldOf("min", 0.0F)
                          .forGetter(LuckLootNumberProvider::min),
                      Codec.FLOAT
                          .optionalFieldOf("max", 1.0F)
                          .forGetter(LuckLootNumberProvider::max))
                  .apply(instance, LuckLootNumberProvider::new));

  @Override
  public class_5657 method_365() {
    return ZombieLootNumberProviderTypes.LUCK;
  }

  @Override
  public float method_32454(class_47 context) {
    return class_3532.method_16439(context.method_302(), min, max);
  }

  public static LuckLootNumberProvider create() {
    return INSTANCE;
  }

  public static LuckLootNumberProvider create(float min, float max) {
    return new LuckLootNumberProvider(min, max);
  }
}
