package org.codeberg.zenxarch.zombies.math;

import java.util.List;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public interface RandomUtils {
  public static boolean nextBoolean(class_5819 random, double chance) {
    return random.method_43058() < chance;
  }

  public static boolean nextBoolean(class_5819 random, double atLeastOnce, int times) {
    var chance = 1.0 - Math.pow(1.0 - atLeastOnce, 1.0 / times);
    return nextBoolean(random, chance);
  }

  public static double nextGaussian(class_5819 random, double mean, double stdDev) {
    return mean + stdDev * random.method_43059();
  }

  public static double logDist(class_5819 random, double mean, double stdDev) {
    return Math.exp(random.method_43059() * stdDev) * mean;
  }

  public static <T> Optional<T> sample(List<T> list, DoubleSupplier rng) {
    if (list.isEmpty()) return Optional.empty();
    var value = 0.0;
    while (true) {
      value = rng.getAsDouble();
      if (value >= 0.0 && value <= 1.0) break;
    }
    var index = class_3532.method_15340((int) (value * list.size()), 0, list.size() - 1);
    return Optional.of(list.get(index));
  }
}
