package org.codeberg.zenxarch.zombies.mixin;

import net.minecraft.class_1937;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.zombies.spawning.SpawnerProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3215.class)
public abstract class ServerChunkManagerMixin {

  @Shadow private boolean spawnMonsters;

  @Shadow
  public abstract class_1937 getWorld();

  @Inject(method = "tickChunks(Lnet/minecraft/util/profiler/Profiler;J)V", at = @At("TAIL"))
  private void zenxarch$handle_spawners(CallbackInfo ci) {
    if (!(getWorld() instanceof class_3218 sw)) return;
    if (!(getWorld() instanceof SpawnerProvider sp)) return;

    for (var spawner : sp.zenxarch$getZombieSpawners()) spawner.spawn(sw, spawnMonsters);
  }
}
